package ru.yandex.canvas.configs;

import java.io.IOException;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.filter.OncePerRequestFilter;

import ru.yandex.direct.tracing.Trace;

@ParametersAreNonnullByDefault
public class XCanvasRequestIdHeaderAppenderFilter extends OncePerRequestFilter {
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response,
                                    FilterChain filterChain) throws IOException, ServletException {
        response.setHeader("X-Canvas-Request-Id", Trace.current().getSpanId() + "");
        filterChain.doFilter(request, response);
    }
}
