package ru.yandex.canvas.configs.auth;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.tvm.AllowServices;

@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)

public @interface AuthorizeBy {
    enum AuthType {DIRECT_TOKEN, TVM_TOKEN, BLACKBOX,
        SANDBOX_SECRET, OAUTH, SANDBOX_CLEANUP_TOKEN,
        TRUSTED_QUERY_STRING
    }
    AuthType[] value() default {AuthType.BLACKBOX};
    AllowServices tvmAllowedServices() default @AllowServices(production = {});
}
