package ru.yandex.canvas.configs.auth;

import javax.servlet.http.HttpServletRequest;

import org.springframework.http.HttpHeaders;

import ru.yandex.canvas.exceptions.AuthException;
import ru.yandex.canvas.exceptions.UnauthorizedException;
import ru.yandex.canvas.service.DirectService;

public class DirectTokenAuthorizer implements CanvasAuthorizer {
    private final DirectService directService;

    public DirectTokenAuthorizer(DirectService directService) {
        this.directService = directService;
    }

    @Override
    public void authorize(HttpServletRequest request, AuthorizeBy handlerMethod)
            throws AuthException, UnauthorizedException
    {
        directService.checkToken(request.getHeader(HttpHeaders.AUTHORIZATION));
    }
}
