package ru.yandex.canvas.configs.auth;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.canvas.exceptions.AuthException;
import ru.yandex.canvas.exceptions.UnauthorizedException;
import ru.yandex.canvas.service.AuthRequestParams;

public class QueryStringAuthorizer implements CanvasAuthorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthRequestParams.class);
    private static final String USER_ID = "user_id";
    private final AuthRequestParams authRequestParams;

    public QueryStringAuthorizer(AuthRequestParams authRequestParams) {
        this.authRequestParams = authRequestParams;
    }

    @Override
    public void authorize(HttpServletRequest request, AuthorizeBy handlerMethod)
            throws AuthException, UnauthorizedException
    {
        String userIdRaw = request.getParameter(USER_ID);

        try {
            if (StringUtils.isNumeric(userIdRaw)) {
                long userId = Long.parseLong(userIdRaw);
                authRequestParams.setUserId(userId);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Got nonparseable user_id  (" + userIdRaw +")");
        }

    }
}
