package ru.yandex.canvas.configs.auth;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.canvas.exceptions.AuthException;
import ru.yandex.canvas.exceptions.UnauthorizedException;

public class SandboxCallbackAuthorizer implements CanvasAuthorizer {
    private final String hookSecret;

    public SandboxCallbackAuthorizer(String hookSecret) {
        this.hookSecret = hookSecret;
    }

    @Override
    public void authorize(HttpServletRequest request, AuthorizeBy authorizeByAnnotation)
            throws AuthException, UnauthorizedException
    {
        String secret = request.getParameter("secret");

        if (!hookSecret.equals(secret)) {
            throw new AuthException("");
        }

    }
}
