package ru.yandex.canvas.configs.auth;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.canvas.exceptions.AuthException;
import ru.yandex.canvas.exceptions.UnauthorizedException;

public class SandboxCleanupHandleAuthorizer implements CanvasAuthorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SandboxCleanupHandleAuthorizer.class);
    private final String internalApiToken;

    public SandboxCleanupHandleAuthorizer(String internalApiToken) {
        this.internalApiToken = internalApiToken;
    }


    @Override
    public void authorize(HttpServletRequest request, AuthorizeBy authorizeByAnnotation)
            throws AuthException, UnauthorizedException
    {
        String secret = request.getParameter("token");

        if (!internalApiToken.equals(secret)) {
            LOGGER.info("Unauthorized access attempt to cleanup handle");
            throw new AuthException("");
        }

    }
}
