package ru.yandex.canvas.controllers;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.configs.auth.AuthorizeBy;
import ru.yandex.canvas.model.Sequence;
import ru.yandex.canvas.service.AuthService;
import ru.yandex.canvas.service.SequenceService;

/**
 * HealthInspectorBean подходит плохо, т.к. в Канвасе нет никакого резона проверять доступность mysql базы
 * какие-то проверки в этот контролер можно добавлять по необходимости
 */
@RestController
@RequestMapping(value = "/alive")
public class AliveController {
    private List<String> expectedSequenceNames = List.of("batchid", "landingid", "creativeid");

    @Autowired
    SequenceService sequenceService;

    @Autowired
    AuthService authService;

    @GetMapping
    @AuthorizeBy({AuthorizeBy.AuthType.TRUSTED_QUERY_STRING})
    public String alive() {
        if (!checkAuth()) {
            return "auth service failed!"; // не достижимо, будет exception
        } else if (!checkMongo()) {
            return "Sequences in mongo check failed!"; // скорее всего тоже не достижим. будет exception
        } else {
            return "ok";
        }
    }

    private boolean checkAuth() {
        return authService.ping().equals("OK");
    }

    private boolean checkMongo() {
        List<String> foundSequences = sequenceService.getSequences().stream().map(Sequence::getId)
                .collect(Collectors.toList());
        return foundSequences.containsAll(expectedSequenceNames);
    }
}
