package ru.yandex.canvas.controllers;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.configs.auth.AuthorizeBy;
import ru.yandex.canvas.model.ffmpeg.FfmpegResolutionsResponse;
import ru.yandex.canvas.service.video.DirectFfmpegResolutions;
import ru.yandex.canvas.service.video.FfmpegResolutions;

import static java.util.stream.Collectors.toList;
import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.DIRECT_TOKEN;

@RestController
@RequestMapping(path = "/ffmpeg-resolutions")
@Validated
public class FfmpegResolutionsDirectController {

    @AuthorizeBy({DIRECT_TOKEN})
    @GetMapping
    public List<FfmpegResolutionsResponse> getFfmpegResolutions(@RequestParam("type") @Valid @NotNull FfmpegResolutionsType type) {
        return type.getFfmpegResolutions()
                .getAllResolutions()
                .stream()
                .map(x -> {
                    String[] wxh = x.getRatio().split(":");
                    int ratioWidth = Integer.parseInt(wxh[0]);
                    int ratioHeight = Integer.parseInt(wxh[1]);
                    return new FfmpegResolutionsResponse(
                            x.getSuffix(), ratioWidth, ratioHeight, x.getWidth(), x.getHeight());
                }).collect(toList());
    }

    private enum FfmpegResolutionsType {
        OUTDOOR_TYPE(DirectFfmpegResolutions.OUTDOOR),
        INDOOR_TYPE(DirectFfmpegResolutions.INDOOR);

        private final FfmpegResolutions ffmpegResolutions;

        FfmpegResolutionsType(FfmpegResolutions ffmpegResolutions) {
            this.ffmpegResolutions = ffmpegResolutions;
        }

        public FfmpegResolutions getFfmpegResolutions() {
            return ffmpegResolutions;
        }
    }

}
