package ru.yandex.canvas.controllers;


import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.bson.internal.Base64;
import org.eclipse.jetty.http.HttpHeader;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.exceptions.BadRequestException;
import ru.yandex.canvas.exceptions.InternalServerError;

@RestController
public class MdsProxyController {
    private static final String MDS_BASE_URL = "https://storage.mds.yandex.net";


    @GetMapping("/mds/{file}")
    public void proxyMds(
            @PathVariable("file") String file,
            HttpServletResponse response)
    {
        String decodedName = new String(Base64.decode(file));
        String mdsUrl = MDS_BASE_URL + "/" + decodedName;

        try {
            HttpRequest httpRequest = HttpRequest.newBuilder(new URI(mdsUrl)).GET().build();

            ServletOutputStream os = response.getOutputStream();

            HttpClient httpClient = HttpClient.newHttpClient();

            HttpResponse<InputStream> httpResponse = httpClient.send(httpRequest,
                    HttpResponse.BodyHandlers.ofInputStream()
            );

            httpResponse.headers().firstValue(HttpHeader.CONTENT_TYPE.asString())
                    .ifPresentOrElse(response::setContentType,
                            () -> response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE));

            response.setStatus(httpResponse.statusCode());
            httpResponse.body().transferTo(os);
        } catch (URISyntaxException e) {
            throw new BadRequestException(e.getMessage());
        } catch (IOException | InterruptedException e) {
            throw new InternalServerError();
        }

    }

}
