package ru.yandex.canvas.controllers;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PagedResponse<T> {
    private List<T> items;

    @JsonProperty("new_offset")
    private Integer newOffset;

    private long total;

    public PagedResponse(List<T> items, @Nullable Integer newOffset, long total) {
        this.items = items;
        this.newOffset = newOffset;
        this.total = total;
    }

    public List<T> getItems() {
        return items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    @Nullable
    public Integer getNewOffset() {
        return newOffset;
    }

    public void setNewOffset(@Nullable Integer newOffset) {
        this.newOffset = newOffset;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }
}
