package ru.yandex.canvas.controllers;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.exceptions.NotFoundException;
import ru.yandex.canvas.model.direct.Privileges;
import ru.yandex.canvas.model.presets.Preset;
import ru.yandex.canvas.model.presets.PresetSelectionCriteria;
import ru.yandex.canvas.model.presets.Presets;
import ru.yandex.canvas.service.AuthService;
import ru.yandex.canvas.service.PresetsService;
import ru.yandex.canvas.service.SessionParams;

/**
 * @author skirsanov
 * @see <a href=https://st.yandex-team.ru/BANNERSTORAGE-3835>BANNERSTORAGE-3835</a>
 */
@RestController
@RequestMapping(value = "/presets")
public class PresetsController {
    private final PresetsService presetsService;
    private final SessionParams sessionParams;
    private final AuthService authService;

    public PresetsController(final PresetsService presetsService,
                             SessionParams sessionParams, AuthService authService) {
        this.presetsService = presetsService;
        this.sessionParams = sessionParams;
        this.authService = authService;
    }

    @GetMapping
    public Presets getList() {
        if (sessionParams.getPresetIds() != null) {
            List<Preset> presets = presetsService.getAll().stream()
                    .filter(p -> sessionParams.getPresetIds().contains(p.getId().longValue()))
                    .collect(Collectors.toList());
            return new Presets(presets);
        } else {
            authService.requirePermission(Privileges.Permission.CREATIVE_GET);
            PresetSelectionCriteria selectionCriteria = PresetSelectionCriteria.fromSessionParams(sessionParams,
                    authService);
            return new Presets(presetsService.getList(selectionCriteria, sessionParams.getClientId(),
                    sessionParams.getInBannerFlag()));
        }
    }

    @GetMapping(value = "{id}")
    public Preset getById(@PathVariable("id") int id) {
        authService.requirePermission(Privileges.Permission.CREATIVE_GET);
        return presetsService.getById(id).orElseThrow(NotFoundException::new);
    }

}
