package ru.yandex.canvas.controllers;

import java.util.List;

import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.configs.auth.AuthorizeBy;
import ru.yandex.canvas.service.AuthService;
import ru.yandex.canvas.service.MongoMonitorService;
import ru.yandex.canvas.service.MongoMonitorService.CountRequestResult;
import ru.yandex.canvas.service.MongoMonitorService.CreativeGroup;

import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.BLACKBOX;
import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.TRUSTED_QUERY_STRING;

/**
 * @author skirsanov
 */
@RestController
public class RootController {

    private MongoMonitorService mongoMonitorService;

    private AuthService authService;

    public RootController(MongoMonitorService mongoMonitorService, AuthService authService) {
        this.mongoMonitorService = mongoMonitorService;
        this.authService = authService;

        HttpComponentsAsyncClientHttpRequestFactory requestFactory = new HttpComponentsAsyncClientHttpRequestFactory();
        requestFactory.setHttpAsyncClient(HttpAsyncClientBuilder.create()
                .setMaxConnPerRoute(100)
                .setMaxConnTotal(100)
                .build());
    }

    @AuthorizeBy({TRUSTED_QUERY_STRING, BLACKBOX})
    @RequestMapping("/ping")
    public String ping() {
        return authService.ping();
    }

    @RequestMapping("/debug/ideasBatches")
    public CountRequestResult ideasBatches(@RequestParam(value = "token") String authToken) {
        return mongoMonitorService.ideasBatches(authToken);
    }

    @RequestMapping("/debug/ideasClients")
    public CountRequestResult ideasClients(@RequestParam(value = "token") String authToken) {
        return mongoMonitorService.ideasClients(authToken);
    }

    @RequestMapping("/debug/clientGroups")
    public List<CreativeGroup> totalCreativesPerClient(@RequestParam(value = "token") String authToken) {
        return mongoMonitorService.totalCreativesPerClient(authToken);
    }
}
