package ru.yandex.canvas.controllers;

import java.util.List;

import javax.validation.constraints.NotNull;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.configs.auth.AuthorizeBy;
import ru.yandex.canvas.model.stock.StockCategory;
import ru.yandex.canvas.service.StockService;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.BLACKBOX;
import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.OAUTH;
import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.TVM_TOKEN;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.LPC_SWITCHCONSTRUCTOR_PROD;
import static ru.yandex.direct.tvm.TvmService.LPC_SWITCHCONSTRUCTOR_TEST;

/**
 * @author pupssman
 */
@RestController
@RequestMapping(value = "stock")
public class StockController {
    private final StockService stockService;

    public StockController(StockService stockService) {
        this.stockService = stockService;
    }

    @AuthorizeBy(value = {BLACKBOX, OAUTH, TVM_TOKEN}, tvmAllowedServices = @AllowServices(testing = {DIRECT_DEVELOPER,
            LPC_SWITCHCONSTRUCTOR_TEST}, production = {LPC_SWITCHCONSTRUCTOR_PROD}))
    @GetMapping(value = "categories")
    public CategoriesDTO categories(@RequestParam(value = "part", defaultValue = "") String query) {
        return CategoriesDTO.fromCategories(stockService.getCategories(query));
    }

    public static class CategoriesDTO {
        private int total;
        private List<StockCategory> items;

        CategoriesDTO(int total, List<StockCategory> items) {
            this.total = total;
            this.items = items;
        }

        static CategoriesDTO fromCategories(@NotNull final List<StockCategory> categories) {
            return new CategoriesDTO(categories.size(), categories);
        }

        public int getTotal() {
            return total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public List<StockCategory> getItems() {
            return items;
        }

        public void setItems(List<StockCategory> items) {
            this.items = items;
        }
    }
}
