package ru.yandex.canvas.controllers;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;

import ru.yandex.canvas.configs.auth.AuthorizeBy;
import ru.yandex.canvas.exceptions.NotFoundException;
import ru.yandex.canvas.model.File;
import ru.yandex.canvas.model.ValidationError;
import ru.yandex.canvas.service.FileService;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.BLACKBOX;
import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.OAUTH;
import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.TVM_TOKEN;
import static ru.yandex.canvas.service.TankerKeySet.ERROR;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.LPC_SWITCHCONSTRUCTOR_PROD;
import static ru.yandex.direct.tvm.TvmService.LPC_SWITCHCONSTRUCTOR_TEST;

/**
 * @author skirsanov
 */
@RestController
@RequestMapping(value = "/files/turbo")
@AuthorizeBy(value = {BLACKBOX, OAUTH, TVM_TOKEN}, tvmAllowedServices = @AllowServices(testing = {DIRECT_DEVELOPER,
        LPC_SWITCHCONSTRUCTOR_TEST}, production = {LPC_SWITCHCONSTRUCTOR_PROD}))
public class TurboFilesController {
    private final FileService fileService;

    public TurboFilesController(final FileService fileService) {
        this.fileService = fileService;
    }

    @ExceptionHandler({HttpClientErrorException.class})
    public ResponseEntity handleHttpError(HttpStatusCodeException e) {
        return ResponseEntity.status(e.getStatusCode()).body(new ValidationError(ERROR.key("image-not-found")));
    }

    @PostMapping(value = "{id}")
    public File turbonizeFile(@PathVariable("id") final String id,
            @RequestParam("client_id") final long clientId)
    {
        return fileService.turbonizedById(id, clientId).orElseThrow(NotFoundException::new);
    }
}
