package ru.yandex.canvas.controllers;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;

import ru.yandex.canvas.exceptions.NotFoundException;
import ru.yandex.canvas.model.File;
import ru.yandex.canvas.model.ValidationError;
import ru.yandex.canvas.service.AuthService;
import ru.yandex.canvas.service.UserFileService;

import static ru.yandex.canvas.service.TankerKeySet.ERROR;

/**
 * Almost the same as TurboFilesController, but for userId instead of clientId.
 * <p>
 * Temporary solution™ for ~1 year (starting from 2018/02/14).
 */
@RestController
@RequestMapping(value = "/user-files/turbo")
public class UserTurboFilesController {
    private final UserFileService fileService;
    private final AuthService authService;

    public UserTurboFilesController(final UserFileService fileService, AuthService authService) {
        this.fileService = fileService;
        this.authService = authService;
    }

    @ExceptionHandler({HttpClientErrorException.class})
    public ResponseEntity handleHttpError(HttpStatusCodeException e) {
        return ResponseEntity.status(e.getStatusCode()).body(new ValidationError(ERROR.key("image-not-found")));
    }

    @PostMapping(value = "{id}")
    public File turbonizeFile(@PathVariable("id") final String id) {
        return fileService.turbonizedById(id, authService.getUserId()).orElseThrow(NotFoundException::new);
    }
}
