package ru.yandex.canvas.controllers;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.configs.auth.AuthorizeBy;
import ru.yandex.canvas.model.direct.Privileges;
import ru.yandex.canvas.service.AuthService;

import static ru.yandex.canvas.configs.auth.AuthorizeBy.AuthType.TRUSTED_QUERY_STRING;

/**
 * @author skirsanov
 */
@RestController
@RequestMapping(value = "/users")
public class UsersController {

    private final AuthService authService;

    public UsersController(final AuthService authService) {
        this.authService = authService;
    }

    @AuthorizeBy({TRUSTED_QUERY_STRING})
    @RequestMapping("/@me")
    public Privileges availableActions() {
        return authService.authenticate();
    }
}
