package ru.yandex.canvas.controllers.html5;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import ru.yandex.canvas.model.html5.SourceWithId;
import ru.yandex.canvas.model.validation.NotWhitespace;

public class BatchCreateRequest {
    @NotNull
    @Size(min = 1, max = 255)
    @NotWhitespace
    private String name;

    @NotNull
    @Size(min = 1, message = "There are should be at least one source")
    @Valid
    private List<SourceWithId> sources;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<SourceWithId> getSources() {
        return sources;
    }

    public void setSources(List<SourceWithId> sources) {
        this.sources = sources;
    }
}
