package ru.yandex.canvas.controllers.html5;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.Html5Constants;
import ru.yandex.canvas.model.Size;
import ru.yandex.canvas.service.html5.Html5Preset;

@RestController
@RequestMapping(path = "/html5/presets")
public class Html5PresetsController {

    public static class Html5Presets {
        private final List<Html5PresetView> items;
        private final int total;

        public Html5Presets(List<Html5PresetView> items) {
            this.items = items;
            this.total = items.size();
        }

        public List<Html5PresetView> getItems() {
            return items;
        }

        public int getTotal() {
            return total;
        }
    }

    public static class Html5PresetView {

        public static class Html5PresetSize {
            private final int width;
            private final int height;

            public Html5PresetSize(Size size) {
                this.height = size.getHeight();
                this.width = size.getWidth();
            }

            public int getWidth() {
                return width;
            }

            public int getHeight() {
                return height;
            }
        }

        private final Long id;
        private final String name;
        private final Html5PresetSize size;

        public Html5PresetView(Html5Preset preset) {
            this.id = (long) preset.getId();
            this.name = preset.getName();
            this.size = new Html5PresetSize(preset.getSize());
        }

        public Long getId() {
            return id;
        }

        public String getName() {
            return name;
        }

        public Html5PresetSize getSize() {
            return size;
        }
    }


    @GetMapping
    public Html5Presets getList(@RequestParam(value = "presetType", required = false) Html5Constants.Html5PresetType presetType) {
        Set<Html5Preset> presets;

        if (presetType != null) {
            presets = Html5Constants.HTML5_PRESETS_BY_TYPE.get(presetType);
        } else {
            presets = Html5Constants.ALL_HTML5_PRESETS;
        }

        List<Html5PresetView> presetViews =
                presets.stream().sorted(Comparator.comparing(Html5Preset::getId))
                        .map(Html5PresetView::new).collect(Collectors.toList());

        return new Html5Presets(presetViews);
    }

}
