package ru.yandex.canvas.controllers.overlay;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Схема, аналогичная схеме Addition - чтобы фронтенд не переделывать
 */
public class OverlayAddition {
    @JsonProperty("preset_id")
    @NotNull
    private Long presetId;

    @JsonProperty("name")
    @NotNull
    private String name;

    @JsonProperty("client_id")
    @NotNull
    private Long clientId;

    @JsonProperty("archive")
    private Boolean archive;

    @JsonProperty("data")
    @NotNull
    @Valid
    private OverlayAdditionData data;

    public Long getPresetId() {
        return presetId;
    }

    public OverlayAddition setPresetId(Long presetId) {
        this.presetId = presetId;
        return this;
    }

    public String getName() {
        return name;
    }

    public OverlayAddition setName(String name) {
        this.name = name;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public OverlayAddition setClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getArchive() {
        return archive;
    }

    public OverlayAddition setArchive(Boolean archive) {
        this.archive = archive;
        return this;
    }

    public OverlayAdditionData getData() {
        return data;
    }

    public OverlayAddition setData(OverlayAdditionData data) {
        this.data = data;
        return this;
    }
}
