package ru.yandex.canvas.controllers.overlay;

import java.util.List;
import java.util.Map;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;

public class OverlayAdditionData {
    @JsonProperty("bundle")
    @NotNull
    private Map<String, Object> bundle;

    @JsonProperty("elements")
    @NotNull
    @Valid
    private List<OverlayAdditionElement> elements;

    public Map<String, Object> getBundle() {
        return bundle;
    }

    public OverlayAdditionData setBundle(Map<String, Object> bundle) {
        this.bundle = bundle;
        return this;
    }

    public List<OverlayAdditionElement> getElements() {
        return elements;
    }

    public OverlayAdditionData setElements(List<OverlayAdditionElement> elements) {
        this.elements = elements;
        return this;
    }
}
