package ru.yandex.canvas.controllers.overlay;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;

public class OverlayAdditionElement {
    @JsonProperty("type")
    @NotNull
    private String type;

    @JsonProperty("available")
    @NotNull
    private Boolean available;

    @JsonProperty("options")
    @NotNull
    @Valid
    private OverlayAdditionElementOptions options;

    public String getType() {
        return type;
    }

    public OverlayAdditionElement setType(String type) {
        this.type = type;
        return this;
    }

    public Boolean getAvailable() {
        return available;
    }

    public OverlayAdditionElement setAvailable(Boolean available) {
        this.available = available;
        return this;
    }

    public OverlayAdditionElementOptions getOptions() {
        return options;
    }

    public OverlayAdditionElement setOptions(OverlayAdditionElementOptions options) {
        this.options = options;
        return this;
    }
}
