package ru.yandex.canvas.controllers.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.model.video.files.FileStatus;
import ru.yandex.canvas.repository.video.VideoFilesRepository;

@RestController
public class DiagnosticsController {

    private VideoFilesRepository videoFilesRepository;

    public DiagnosticsController(VideoFilesRepository videoFilesRepository) {
        this.videoFilesRepository = videoFilesRepository;
    }

    public static class DiagnosticsResponse {
        @JsonProperty("video_files.not_converted")
        private long notConverted;

        @JsonProperty("video_files.custom_files_count")
        private long customVideos;

        public DiagnosticsResponse setNotConverted(long notConverted) {
            this.notConverted = notConverted;
            return this;
        }

        public DiagnosticsResponse setCustomVideos(long customVideos) {
            this.customVideos = customVideos;
            return this;
        }
    }

    @GetMapping(value = "/video/diagnostics")
    public DiagnosticsResponse getDiagnostics() {
        VideoFilesRepository.QueryBuilder notConvertedQuery = new VideoFilesRepository.QueryBuilder()
                .withStatusNotIn(null, FileStatus.READY)
                .withArchive(false);

        VideoFilesRepository.QueryBuilder customVideosCount = new VideoFilesRepository.QueryBuilder()
                .withStockFileId(null);

        DiagnosticsResponse response = new DiagnosticsResponse();

        response.setNotConverted(videoFilesRepository.count(notConvertedQuery));
        response.setCustomVideos(videoFilesRepository.count(customVideosCount));

        return response;
    }
}
