package ru.yandex.canvas.controllers.video;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.controllers.OffsetTotalItemsResponse;
import ru.yandex.canvas.service.video.files.CategoriesRecord;
import ru.yandex.canvas.service.video.files.StockMoviesService;
import ru.yandex.canvas.service.video.files.VideoCategoriesService;

@RestController
@RequestMapping(path = "/video/stock")
@Validated
public class StockVideoController {

    private StockMoviesService stockMoviesService;
    private VideoCategoriesService videoCategoriesService;

    public StockVideoController(StockMoviesService stockMoviesService,
                                VideoCategoriesService videoCategoriesService) {
        this.stockMoviesService = stockMoviesService;
        this.videoCategoriesService = videoCategoriesService;
    }

    public static class GroupRecord {
        private long id;
        private String name;

        public long getId() {
            return id;
        }

        public GroupRecord setId(long id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return name;
        }

        public GroupRecord setName(String name) {
            this.name = name;
            return this;
        }

        public GroupRecord(long id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    @GetMapping(path = "/groups")
    public ResponseEntity<OffsetTotalItemsResponse<GroupRecord>> getStockGroups(@RequestParam(value = "part", required = false) String stockGroupNameSubstr) {
        List<String> groups = stockMoviesService.getGroups();

        List<GroupRecord> result = new ArrayList<>();

        for (int i = 0; i < groups.size(); i++) {
            if (stockGroupNameSubstr != null && !groups.get(i).contains(stockGroupNameSubstr)) {
                continue;
            }

            result.add(new GroupRecord(i + 1, groups.get(i)));
        }

        return ResponseEntity.ok(new OffsetTotalItemsResponse<>(result, 0, result.size()));
    }


    @GetMapping(path = "/categories")
    public ResponseEntity<OffsetTotalItemsResponse<CategoriesRecord>> getStockCategories(@RequestParam(value = "part", required = false) String categoryNameSubstr) {
        Collection<CategoriesRecord> categoriesRecords = videoCategoriesService.getCategoriesMap().values();

        List<CategoriesRecord> result = new ArrayList<>();

        for (CategoriesRecord record : categoriesRecords) {
            if (categoryNameSubstr != null && !record.getName().contains(categoryNameSubstr)) {
                continue;
            }

            result.add(record);
        }

        return ResponseEntity.ok(new OffsetTotalItemsResponse<CategoriesRecord>(result, 0, result.size()));
    }

}
