package ru.yandex.canvas.controllers.video;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.model.video.Addition;

public class VideoAdditionItemResponse {

    @JsonProperty
    private String id;

    @JsonProperty("preset_id")
    private Long presetId;

    @JsonProperty("name")
    private String name;

    @JsonProperty("client_id")
    private Long clientId;

    @JsonProperty("archive")
    private Boolean archive;

    @JsonProperty("date")
    private Date date;

    @JsonProperty("data")
    private VideoAdditionItemDataResponse data;

    @JsonProperty("vast")
    private String vast;

    @JsonProperty("screenshot_url")
    private String screenshotUrl;

    @JsonProperty("creative_id")
    private Long creativeId;

    @JsonProperty("stock_creative_id")
    private Long stockCreativeId;

    @JsonProperty("previewUrl")
    private String previewUrl;

    @JsonProperty("has_packshot")
    private Boolean hasPackshot;

    public VideoAdditionItemResponse(Addition addition) {
        this.id = addition.getId();
        this.archive = addition.getArchive();
        this.clientId = addition.getClientId();
        this.creativeId = addition.getCreativeId();
        this.date = addition.getDate();
        this.name = addition.getName();
        this.presetId = addition.getPresetId();
        this.screenshotUrl = addition.getScreenshotUrl();
        this.previewUrl = addition.getPreviewUrl();
        this.stockCreativeId = addition.getStockCreativeId();
        this.vast = addition.getVast();

        if (addition.findFilesOptions() == null) {
            this.hasPackshot = false;
        } else {
            this.hasPackshot = addition.findFilesOptions().getPackshotId() != null;
        }

        VideoAdditionItemDataResponse data = new VideoAdditionItemDataResponse();
        data.setBundle(new VideoAdditionItemDataResponse.Bundle().setName(addition.getData().getBundle().getName()));
        data.setElements(addition.getData().getElements());
        this.data = data;
    }

    public VideoAdditionItemResponse setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public VideoAdditionItemResponse setHasPackshot(Boolean hasPackshot) {
        this.hasPackshot = hasPackshot;
        return this;
    }
}
