package ru.yandex.canvas.controllers.video;

import java.io.IOException;
import java.net.URISyntaxException;

import javax.validation.Valid;

import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.canvas.configs.auth.AuthorizeBy;
import ru.yandex.canvas.exceptions.InternalServerError;
import ru.yandex.canvas.model.direct.Privileges;
import ru.yandex.canvas.service.AuthService;
import ru.yandex.canvas.service.rtbhost.helpers.VideoMotionService;

@RestController
@RequestMapping(path = "/video/additions")
@Validated
public class VideoMotionController {
    private AuthService authService;
    private VideoMotionService videoMotionService;

    public VideoMotionController(AuthService authService,
                                 VideoMotionService videoMotionService) {
        this.authService = authService;
        this.videoMotionService = videoMotionService;
    }

    @PostMapping(path = "/video-motion/preview")
    public ResponseEntity<PreviewResponseEntity> getVideoMotionPreview(
            @Valid @RequestBody PreviewRequestEntity previewRequest
    ) {
        authService.requirePermission(Privileges.Permission.CREATIVE_GET);

        try {
            return ResponseEntity.ok(new PreviewResponseEntity(
                    videoMotionService.getVideoMotionPreview(previewRequest.getPreviewData())));
        } catch (URISyntaxException | IOException e) {
            throw new InternalServerError();
            //TODO logging
        }
    }

    @AuthorizeBy({AuthorizeBy.AuthType.DIRECT_TOKEN})
    @PostMapping(path = "video-motion/rtb_host_export")
    public ResponseEntity exportVideoMotionToRtbHost() {
        videoMotionService.sendVideoMotiontoRtbHost();
        return ResponseEntity.ok(null);
    }

}
