package ru.yandex.canvas.controllers.video.wrappers;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import ru.yandex.canvas.controllers.video.DateSerializer;
import ru.yandex.canvas.model.video.files.AudioSource;

import static java.util.Collections.emptyList;

public class AudioFileWrapper implements FileWrapper {
    @JsonIgnore
    private final AudioSource audioSource;

    public AudioFileWrapper(AudioSource audioSource) {
        this.audioSource = audioSource;
    }

    @JsonProperty("archive")
    public Boolean getArchive() {
        return false;
    }

    @JsonProperty("duration")
    public Long getDuration() {
        return audioSource.getDuration();
    }

    @JsonProperty("id")
    public String getId() {
        return audioSource.getId();
    }

    @JsonProperty("name")
    public String getName() {
        return audioSource.getName();
    }

    @JsonProperty("originalName")
    public String getOriginalName() {
        return audioSource.getName();
    }

    @JsonProperty("type")
    public String getType() {
        return "audio";
    }

    @JsonProperty("sub_categories")
    public List<String> getSubCategories() {
        return emptyList();
    }

    @JsonProperty("url")
    public String getUrl() {
        return audioSource.getStillageUrl();
    }

    @JsonProperty("stock_file_id")
    public String getStockFileId() {
        return audioSource.getStockId();
    }

    @JsonProperty("date")
    @JsonSerialize(using = DateSerializer.class)
    public Date getDate() {
        return audioSource.getDate();
    }

    @JsonProperty("client_id")
    public Long clientId() {
        return audioSource.getClientId();
    }

}
