package ru.yandex.canvas.controllers.video.wrappers;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import ru.yandex.canvas.VideoConstants;
import ru.yandex.canvas.controllers.video.DateSerializer;
import ru.yandex.canvas.model.video.files.FileStatus;
import ru.yandex.canvas.model.video.files.InBannerVideo;
import ru.yandex.canvas.model.video.files.Thumbnail;
import ru.yandex.canvas.service.TankerKeySet;

public class InBannerWrapper implements FileWrapper {
    @JsonIgnore
    private final InBannerVideo movie;

    public InBannerWrapper(InBannerVideo movie) {
        this.movie = movie;
    }

    @JsonProperty("archive")
    public Boolean getArchive() {
        return movie.getArchive();
    }

    @JsonProperty("id")
    public String getId() {
        return movie.getId();
    }

    @JsonProperty("name")
    public String getName() {
        return movie.getName();
    }

    @JsonProperty("formats")
    public List<VideoFileFormatRecord> getFormat() {

        return movie.getFormats().stream()
                .map(e -> new VideoFileFormatRecord(e.getUrl(), e.getBitrate(), e.getDelivery(), e.getMimeType()))
                .collect(Collectors.toList());
    }

    @JsonProperty("status")
    public FileStatus getStatus() {
        return movie.getStatus();
    }

    @JsonProperty("conversion_task_id")
    public Long getConversionTaskId() {
        return movie.getConvertionTaskId();
    }

    @JsonProperty("overlayColor")
    public String getOverlayColor() {
        return movie.getOverlayColor();
    }

    @JsonProperty("stillage_id")
    public String getStillageId() {
        return movie.getStillageId();
    }

    @JsonProperty("type")
    public String getType() {
        return "video";
    }

    @JsonProperty("date")
    @JsonSerialize(using = DateSerializer.class)
    public Date getDate() {
        return movie.getDate();
    }

    @JsonProperty("client_id")
    public Long clientId() {
        return movie.getClientId();
    }

    @JsonProperty("url")
    public String getUrl() {
        return movie.getStillageUrl();
    }

    @JsonProperty("thumbnail")
    public Thumbnail getThumbnail() {
        return movie.getThumbnail();
    }

    @JsonProperty("thumbnailUrl")
    public String getThumbnailUrl() {

        if (movie.getThumbnail() == null
                || movie.getThumbnail().getUrl() == null) {
            return VideoConstants.DEFAULT_THUMBNAIL_URL;
        }

        return movie.getThumbnail().getUrl();
    }

    @JsonProperty("error_message")
    public String getErrorMessage() {
        if (movie.getStatus() == FileStatus.ERROR) {
            return TankerKeySet.VIDEO.key("failed_to_convert_file");
        }

        return null;
    }

    public static class VideoFileFormatRecord {
        private String url;
        private Long bitrate;
        private String delivery;
        private String type;

        public VideoFileFormatRecord(String url, Long bitrate, String delivery, String type) {
            this.url = url;
            this.bitrate = bitrate;
            this.delivery = delivery;
            this.type = type;
        }

        public String getType() {
            return type;
        }

        public String getUrl() {
            return url;
        }

        public Long getBitrate() {
            return bitrate;
        }

        public String getDelivery() {
            return delivery;
        }
    }

}
