package ru.yandex.canvas.controllers.video.wrappers;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import ru.yandex.canvas.controllers.video.DateSerializer;
import ru.yandex.canvas.model.video.files.FileStatus;
import ru.yandex.canvas.model.video.files.PackShot;

public class PackshotFileWrapper implements FileWrapper {
    @JsonIgnore
    private PackShot packShot;

    public Boolean getArchive() {
        return packShot.getArchive();
    }

    @JsonProperty("formats")
    public List<PackShot.ImageFormat> getFormat() {
        return packShot.getFormats();
    }

    @JsonProperty("id")
    public String getId() {
        return packShot.getId();
    }

    @JsonProperty("largePreviewUrl")
    public String getLargePreviewUrl() {
        return packShot.getLargePreviewUrl();
    }

    @JsonProperty("name")
    public String getName() {
        return packShot.getName();
    }

    @JsonProperty("previewUrl")
    public String getPreviewUrl() {
        return packShot.getPreviewUrl();
    }

    @JsonProperty("status")
    public FileStatus getStatus() {
        return FileStatus.READY;
    }

    @JsonProperty("stillage_id")
    public Long getStillageId() {
        return packShot.getStillageId();
    }

    @JsonProperty("thumbnailUrl")
    public String getThumbnailUrl() {
        return packShot.getThumbnailUrl();
    }

    @JsonProperty("type")
    public String getType() {
        return "image";
    }

    @JsonProperty("url")
    public String getUrl() {
        return packShot.getStillageUrl();
    }

    @JsonProperty("date")
    @JsonSerialize(using = DateSerializer.class)
    public Date getDate() {
        return packShot.getDate();
    }

    public PackshotFileWrapper(PackShot packShot) {
        this.packShot = packShot;
    }
}
