package ru.yandex.canvas.exceptions;

import java.util.List;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;

/*
 Do NOT annotate this exception like @ResponseStatus(value = HttpStatus.BAD_REQUEST)
 Because of custom message format (see GlobalExceptionHandler).
 */
public class SourceValidationError extends RuntimeException {

    public SourceValidationError(String message) {
        this(ImmutableList.of(message));
    }

    public SourceValidationError(List<String> messages) {
        super(new Gson().toJson(ImmutableMap.of("messages", messages)));
    }
}
