package ru.yandex.canvas.exceptions;

import java.util.List;

import ru.yandex.canvas.model.ValidationError;

public class ValidationErrorsException extends ValidationResultRepresentationException {
    private final List<String> messages;

    public ValidationErrorsException(List<String> messages) {
        this.messages = messages;
    }

    public List<String> getMessages() {
        return messages;
    }

    @Override
    public ValidationError getValidationErrorRepresentation() {
        return new ValidationError(String.join("\n", getMessages()));
    }
}
