package ru.yandex.canvas.exceptions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

import ru.yandex.canvas.model.ValidationError;

public class VideoAdditionCreationValidationException extends ValidationResultRepresentationException {
    private String message;
    private BindingResult bindingResult;

    /*  В питоне есть база с конкатенацией - пропущена точка между elements[0] и options
        на время переписывания повторяем это поведение
        TODO: оторвать когда откажемся от video-конструктора на питоне (проверить что фронт обрабатывает правильно) */
    private static Pattern elementOptionsPattern = Pattern.compile("^elements\\[(\\d+)\\].options");

    public VideoAdditionCreationValidationException(String message, BindingResult bindingResult) {
        this.message = message;
        this.bindingResult = bindingResult;
    }

    public static String convertFieldName(String fieldNameModelStyle) {
        return pathReplacements(
                removePrefix(
                        toUnderScore(fieldNameModelStyle)));
    }

    private static String pathReplacements(String fieldName) {
        Matcher elementOptionMatcher = elementOptionsPattern.matcher(fieldName);
        if (elementOptionMatcher.lookingAt()) {
            int elementNumber = Integer.parseInt(elementOptionMatcher.group(1));
            String newPathPrefix = String.format("elements[%s]options", elementNumber);
            return elementOptionMatcher.replaceFirst(newPathPrefix);
        } else {
            return fieldName;
        }
    }

    private static String toUnderScore(String field) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field);
    }

    private static String removePrefix(String field) {
        return field.startsWith("data.") ? field.replaceFirst("data.", "") : field;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public ValidationError getValidationErrorRepresentation() {
        return new ValidationError(getMessage(), bindingResult.getAllErrors().stream()
                .collect(Collectors.toMap(
                        // put FieldErrors to the field key and other errors to the "" key
                        e -> (e instanceof FieldError) ? convertFieldName(((FieldError) e).getField()) : "",
                        e -> Lists.newArrayList(e.getDefaultMessage()),
                        (e1, e2) -> {
                            e1.addAll(e2);
                            return e1;
                        })));
    }
}
