package ru.yandex.canvas.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * @author skirsanov
 */
public abstract class AbstractMediaSetSubItem {

    @NotNull
    protected String url;

    @NotNull
    private Integer width;

    @NotNull
    private Integer height;

    private String alias;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private List<SmartCenter> smartCenters;

    private Map<String, Object> additionalProperties = new HashMap<>();


    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<SmartCenter> getSmartCenters() {
        return smartCenters;
    }

    public void setSmartCenters(List<SmartCenter> smartCenters) {
        this.smartCenters = smartCenters;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperties(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "AbstractMediaSetSubItem{" +
                "width=" + width +
                ", height=" + height +
                ", url='" + url + '\'' +
                ", alias='" + alias + '\'' +
                ", additionalProperties=" + additionalProperties +
                ", smartCenters=" + smartCenters +
                '}';
    }
}
