package ru.yandex.canvas.model;

import java.util.Objects;

import javax.validation.constraints.NotNull;

/**
 * Created by pupssman on 12.01.17.
 */
public class Bundle {
    @NotNull
    private String name;

    private int version;

    public Bundle(String name, int version) {
        this.name = name;
        this.version = version;
    }

    public Bundle() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "Bundle{name=" + name + ", version=" + version + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Bundle bundle = (Bundle) o;

        if (version != bundle.version) {
            return false;
        }
        return Objects.equals(name, bundle.name);
    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + version;
        return result;
    }
}
