package ru.yandex.canvas.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ComparisonChain;

/**
 * @author skirsanov
 */
public abstract class CreativeDimension<T extends CreativeDimension> implements Comparable<CreativeDimension> {

    @NotNull
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer width;

    @NotNull
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer height;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer logoWidth;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer logoHeight;

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getLogoWidth() {
        return logoWidth;
    }

    public void setLogoWidth(Integer logoWidth) {
        this.logoWidth = logoWidth;
    }

    public Integer getLogoHeight() {
        return logoHeight;
    }

    public void setLogoHeight(Integer logoHeight) {
        this.logoHeight = logoHeight;
    }

    @SuppressWarnings("unchecked")
    public T withWidth(Integer width) {
        this.width = width;
        return (T) this;
    }

    @SuppressWarnings("unchecked")
    public T withHeight(Integer height) {
        this.height = height;
        return (T) this;
    }

    /**
     * @return true if element should go first during sorting
     * @see <a href="https://st.yandex-team.ru/BANNERSTORAGE-4283">BANNERSTORAGE-4283</a>
     */
    @JsonIgnore
    public boolean goesFirst() {
        return width == 300 && height == 250;
    }


    @Override
    public int compareTo(CreativeDimension other) {
        return ComparisonChain.start()
                .compareTrueFirst(goesFirst(), other.goesFirst())
                .compare(width, other.width)
                .compare(height, other.height)
                .result();
    }


    @Override
    public String toString() {
        return "CreativeDimension{" +
                "width=" + width +
                ", height=" + height +
                '}';
    }

    /**
     * Статический equals для возможности сравнения сабклассов
     */
    public static boolean equals(@Nullable CreativeDimension first, @Nullable CreativeDimension second) {
        if (first == null && second == null) {
            return true;
        }

        if (first == null || second == null) {
            return false;
        }

        return Objects.equals(first.width, second.width) && Objects.equals(first.height, second.height);
    }
}
