package ru.yandex.canvas.model;

/**
 * Hold crop geometry for a file -- position of cropped area as x/y offsets from top/left corner and width/height.
 * <p>
 * Created by pupssman on 15.03.17.
 */
public class CropParameters {
    private double width;
    private double height;
    private double y;
    private double x;

    public CropParameters() {
    }

    public CropParameters(double width, double height, double y, double x) {
        this.width = width;
        this.height = height;
        this.y = y;
        this.x = x;
    }

    public double getWidth() {
        return width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getY() {
        return y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getX() {
        return x;
    }

    public void setX(double x) {
        this.x = x;
    }

    @Override
    public String toString() {
        return "CropParameters{" +
                "width=" + width +
                ", height=" + height +
                ", y=" + y +
                ", x=" + x +
                '}';
    }
}
