package ru.yandex.canvas.model;

import com.fasterxml.jackson.annotation.JsonGetter;

public class DraftCreative {

    private CreativeData data;
    private Integer presetId;
    /**
     * integer like {presetId}000{presetItemId}. To make id unique among all presets items and sizes
     */
    private Integer id;

    public DraftCreative(Integer presetId,
                         CreativeData data,
                         Integer id) {
        this.data = data;
        this.presetId = presetId;
        this.id = id;
    }

    public DraftCreative() {
    }

    public CreativeData getData() {
        return data;
    }

    public void setData(CreativeData data) {
        this.data = data;
    }

    public Integer getPresetId() {
        return presetId;
    }

    public void setPresetId(Integer presetId) {
        this.presetId = presetId;
    }

    @JsonGetter("id")
    public Integer getPresetItemId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}
