package ru.yandex.canvas.model;

import java.util.List;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.service.scraper.URLHelper;

public class DraftCreativeBatch {
    private String ideaId;

    private String url;

    private String name;

    private List<DraftCreative> items;

    @JsonCreator
    public DraftCreativeBatch(@JsonProperty("ideaId") String ideaId,
                              @JsonProperty("url") String url,
                              @JsonProperty("name") String name,
                              @JsonProperty("items") List<DraftCreative> items
    ) {
        this.ideaId = ideaId;
        this.url = url;
        this.name = name;
        this.items = items;
    }

    public DraftCreativeBatch(@NotNull List<DraftCreative> items, @NotNull IdeaDocument idea) {
        this.ideaId = idea.getId();
        this.url = idea.getRequestedUrl();
        this.name = URLHelper.normalizeUrl(idea.getRequestedUrl()).getHost();
        this.items = items;
    }

    public String getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(String ideaId) {
        this.ideaId = ideaId;
    }

    public List<DraftCreative> getItems() {
        return items;
    }

    public void setItems(List<DraftCreative> items) {
        this.items = items;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
