package ru.yandex.canvas.model;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;

import ru.yandex.canvas.model.scraper.ScraperData;

import static ru.yandex.canvas.model.IdeaDocument.IDEA_COLLECTION;

/**
 * @author solovyev
 */
@Document(collection = IDEA_COLLECTION)
@CompoundIndexes({
        @CompoundIndex(def = "{'clientId': 1, 'archive': 1}")
})
public class IdeaDocument {
    public static final String IDEA_COLLECTION = "idea";

    @Id
    private String id;

    private long clientId;

    private Date date;

    private String requestedUrl;

    @NotNull
    private ScraperData scraperData;

    @JsonIgnore
    private boolean archive;


    @JsonCreator
    public IdeaDocument(@JsonProperty("scraperData") ScraperData scraperData,
                        @JsonProperty("clientId") long clientId,
                        @JsonProperty("date") Date date,
                        @JsonProperty("requestedUrl") String requestedUrl) {
        this.clientId = clientId;
        this.date = date;
        this.scraperData = scraperData;
        this.requestedUrl = requestedUrl;
        this.archive = false;
    }

    public IdeaDocument() {
    }

    public Date getDate() {
        return date;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getClientId() {
        return clientId;
    }

    public boolean isArchive() {
        return archive;
    }

    public ScraperData getScraperData() {
        return scraperData;
    }

    public String getRequestedUrl() {
        return requestedUrl;
    }

    @Override
    public String toString() {
        return "IdeaDocument{" +
                "id='" + id + '\'' +
                ", clientId=" + clientId +
                ", date=" + date +
                ", requestedUrl='" + requestedUrl + '\'' +
                ", scraperData=" + scraperData +
                ", archive=" + archive +
                '}';
    }
}
