package ru.yandex.canvas.model;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

//to serialize actions and features in lower case
public class LowerCaseSerializer<T extends Enum> extends JsonSerializer<T> {
    @Override
    public void serialize(T value, JsonGenerator generator,
                          SerializerProvider provider) throws IOException {
        generator.writeString(value.name().toLowerCase());
    }
}
