package ru.yandex.canvas.model;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;


/**
 * MediaSet -- set of media elements (images/videos/sounds/etc) to be referred by an element
 *
 * @author pupssman
 */
public class MediaSet extends AbstractMediaSet<MediaSetItem> {

    @Valid
    @NotNull
    private List<MediaSetItem> items;

    @Override
    public List<MediaSetItem> getItems() {
        return items;
    }

    @Override
    public void setItems(List<MediaSetItem> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "MediaSet{" +
                "items=" + items +
                '}';
    }
}
