package ru.yandex.canvas.model;

import com.fasterxml.jackson.annotation.JsonIgnore;


/**
 * Lowest-level mediaSet element, e.g. a particular picture.
 * <p>
 * TODO: review validation and field when entries other that images get here.
 *
 * @author pupssman
 */
public class MediaSetSubItem extends AbstractMediaSetSubItem {

    private String fileId;
    private String croppedFileId;

    @JsonIgnore
    private boolean defaultValue;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getCroppedFileId() {
        return croppedFileId;
    }

    public void setCroppedFileId(String croppedFileId) {
        this.croppedFileId = croppedFileId;
    }


    @JsonIgnore
    public String getEffectiveFileId() {
        return croppedFileId != null ? croppedFileId : fileId;
    }


    @Override
    public String toString() {
        return "MediaSetSubItem{" +
                "fileId=" + fileId +
                ", croppedFileId=" + croppedFileId +
                "} " + super.toString();
    }

    public boolean isDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }
}
