package ru.yandex.canvas.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class Size implements Comparable<Size> {
    private final int width;
    private final int height;

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Size(Size size) {
        this(size.getWidth(), size.getHeight());
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Size size = (Size) o;
        return width == size.width &&
                height == size.height;
    }

    @Override
    public int hashCode() {
        return Objects.hash(width, height);
    }

    @Override
    public String toString() {
        return (width == 0 ? "?" : width) + "x" + height;
    }

    public String toFilterString() {
        return width + "x" + height;
    }

    public static Size of(int width, int height) {
        return new Size(width, height);
    }

    public static Size of(int[] dims) {
        return Size.of(dims[0], dims[1]);
    }

    @Override
    public int compareTo(@NotNull Size o) {
        return this.toString().compareTo(o.toString());
    }
}
