package ru.yandex.canvas.model;

import java.io.IOException;
import java.io.UncheckedIOException;

import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * General-purpose utility methods for model objects.
 * <p>
 * Created by pupssman on 10.04.17.
 */
public interface Util {
    static <T> T deepcopy(ObjectMapper mapper, Object source, Class<T> destinationClass) {
        try {
            return mapper.readValue(mapper.writeValueAsBytes(source), destinationClass);
        } catch (IOException e) {
            throw new UncheckedIOException(e);  // these IOExceptions should never happen as we use in-memory conversion
        }
    }
}
