package ru.yandex.canvas.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

import ru.yandex.direct.tracing.Trace;


/**
 * Validation error for front-end
 *
 * @author pupssman
 * @property message main validation error message
 * @property properties per-field validation error messages
 */
public class ValidationError {
    private String message;
    private Map<String, List<String>> properties;
    private String id;

    public ValidationError(String message) {
        this(message, new HashMap<>());
    }

    public ValidationError(String message, Map<String, List<String>> properties) {
        this.message = message;
        this.properties = properties;
        this.id = Trace.current().getSpanId() + "";
    }

    public ValidationError(String message, BindingResult bindingResult) {
        this(message,
                bindingResult.getAllErrors().stream()
                        .collect(Collectors.toMap(
                                // put FieldErrors to the field key and other errors to the "" key
                                e -> (e instanceof FieldError) ? ((FieldError) e).getField() : "",
                                e -> Lists.newArrayList(e.getDefaultMessage()),  // FIXME: need localization here
                                (e1, e2) -> {
                                    e1.addAll(e2);
                                    return e1;
                                })));
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, List<String>> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, List<String>> properties) {
        this.properties = properties;
    }

    public String getId() {
        return id;
    }

    public ValidationError setId(String id) {
        this.id = id;
        return this;
    }
}
