package ru.yandex.canvas.model.avatars;

import java.util.Arrays;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class AvatarsPutCanvasResult implements AvatarsPutResult {
    @JsonProperty("group-id")
    private int groupId;

    private MetaInfo meta;

    private SizesInfo sizes;

    public int getGroupId() {
        return groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public MetaInfo getMeta() {
        return meta;
    }

    public void setMeta(MetaInfo meta) {
        this.meta = meta;
    }

    public SizesInfo getSizes() {
        return sizes;
    }

    public void setSizes(SizesInfo sizes) {
        this.sizes = sizes;
    }

    @Override
    public String toString() {
        return "AvatarsPutCanvasResult{" +
                "groupId=" + groupId +
                ", meta=" + meta +
                ", sizes=" + sizes +
                '}';
    }

    public static class MetaInfo {
        @JsonProperty("orig-size")
        private OrigSizeInfo origSize;

        private String md5;

        @JsonProperty("orig-format")
        private String origFormat;

        @JsonProperty("processed_by_computer_vision")
        private Boolean processedByComputerVision;

        @JsonProperty("processed_by_computer_vision_description")
        private String processedByComputerVisionDescription;

        private String processing;

        public String getMd5() {
            return md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public String getOrigFormat() {
            return origFormat;
        }

        public void setOrigFormat(String origFormat) {
            this.origFormat = origFormat;
        }

        public Boolean getProcessedByComputerVision() {
            return processedByComputerVision;
        }

        public void setProcessedByComputerVision(Boolean processedByComputerVision) {
            this.processedByComputerVision = processedByComputerVision;
        }

        public String getProcessedByComputerVisionDescription() {
            return processedByComputerVisionDescription;
        }

        public void setProcessedByComputerVisionDescription(String processedByComputerVisionDescription) {
            this.processedByComputerVisionDescription = processedByComputerVisionDescription;
        }

        public String getProcessing() {
            return processing;
        }

        public void setProcessing(String processing) {
            this.processing = processing;
        }

        public OrigSizeInfo getOrigSize() {
            return origSize;
        }

        public void setOrigSize(OrigSizeInfo origSize) {
            this.origSize = origSize;
        }

        @Override
        public String toString() {
            return "MetaInfo{" +
                    "origSize=" + origSize +
                    ", md5='" + md5 + '\'' +
                    ", origFormat='" + origFormat + '\'' +
                    ", processedByComputerVision=" + processedByComputerVision +
                    ", processedByComputerVisionDescription='" + processedByComputerVisionDescription + '\'' +
                    ", processing='" + processing + '\'' +
                    '}';
        }

        public static class OrigSizeInfo {
            private int x;
            private int y;

            public int getX() {
                return x;
            }

            public void setX(int x) {
                this.x = x;
            }

            public int getY() {
                return y;
            }

            public void setY(int y) {
                this.y = y;
            }

            @Override
            public String toString() {
                return "OrigSizeInfo{" +
                        "x=" + x +
                        ", y=" + y +
                        '}';
            }
        }
    }

    public static class SizeInfo {
        private int width;
        private int height;
        private String path;
        private String url;

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getWidth() {
            return width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String getPath() {
            return path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public String toString() {
            return "SizeInfo{" +
                    "width=" + width +
                    ", height=" + height +
                    ", path='" + path + '\'' +
                    '}';
        }
    }

    public static class SizesInfo {

        private SizeInfo orig;
        private SizeInfo optimize;
        private SizeInfo preview;
        private SizeInfo largePreview;
        private SizeInfo thumbnail;
        private SizeInfo cropSource;
        private SizeInfo preview480p;

        public List<SizeInfo> allSizes() {
            return Arrays.asList(orig, optimize, preview, largePreview, thumbnail, cropSource, preview480p);
        }

        public SizeInfo getOptimize() {
            return optimize;
        }

        public void setOptimize(SizeInfo optimize) {
            this.optimize = optimize;
        }

        public SizeInfo getPreview() {
            return preview;
        }

        public void setPreview(SizeInfo preview) {
            this.preview = preview;
        }

        public SizeInfo getThumbnail() {
            return thumbnail;
        }

        public void setThumbnail(SizeInfo thumbnail) {
            this.thumbnail = thumbnail;
        }

        public SizeInfo getOrig() {
            return orig;
        }

        public SizeInfo getPreview480p() {
            return preview480p;
        }

        public void setPreview480p(SizeInfo preview480p) {
            this.preview480p = preview480p;
        }

        public void setOrig(SizeInfo orig) {
            this.orig = orig;
        }

        public SizeInfo getLargePreview() {
            return largePreview;
        }

        public void setLargePreview(SizeInfo largePreview) {
            this.largePreview = largePreview;
        }

        public SizeInfo getCropSource() {
            return cropSource;
        }

        public void setCropSource(SizeInfo cropSource) {
            this.cropSource = cropSource;
        }

        @Override
        public String toString() {
            return "SizesInfo{" +
                    "orig=" + orig +
                    ", preview=" + preview +
                    ", largePreview=" + largePreview +
                    ", preview480p=" + preview480p +
                    ", thumbnail=" + thumbnail +
                    ", cropSource=" + cropSource +
                    '}';
        }
    }
}
