package ru.yandex.canvas.model.avatars;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.web.util.UriComponentsBuilder;

import ru.yandex.canvas.model.TurboParameters;
import ru.yandex.canvas.model.stillage.StillageFileInfo;
import ru.yandex.canvas.service.AvatarsService;

public class AvatarsPutTurboResult implements AvatarsPutResult {
    @JsonProperty("group-id")
    private int groupId;

    private MetaInfo meta = new MetaInfo();
    @JsonProperty("imagename")
    private String imageName;

    public StillageFileInfo.ImageColors getImageColors() {
        return new StillageFileInfo.ImageColors(meta.averageBorderColor, meta.colorWizBack, meta.colorWizButton,
                meta.colorWizButtonText, meta.colorWizText);
    }

    public void setImageColors(@NotNull StillageFileInfo.ImageColors imageColors) {
        meta.averageBorderColor = imageColors.getAverageBorderColor();
        meta.colorWizBack = imageColors.getColorWizBack();
        meta.colorWizButton = imageColors.getColorWizButton();
        meta.colorWizButtonText = imageColors.getColorWizButtonText();
        meta.colorWizText = imageColors.getColorWizText();
    }

    public int getGroupId() {
        return groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public MetaInfo getMeta() {
        return meta;
    }

    public void setMeta(MetaInfo meta) {
        this.meta = meta;
    }

    public String getImageName() {
        return imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public TurboParameters toTurboParameters(@NotNull String avatarnicaBaseUrl) {
        return new TurboParameters(getImageColors(),
                UriComponentsBuilder
                        .fromHttpUrl(avatarnicaBaseUrl)
                        .path("/get-" + AvatarsService.TURBO_NAMESPACE)
                        .pathSegment(Integer.toString(groupId))
                        .pathSegment(imageName)
                        .build()
                        .toString()
        );

    }

    @Override
    public String toString() {
        return "AvatarsPutCanvasResult{" +
                "groupId=" + groupId +
                ", meta=" + meta +
                '}';
    }

    public static class MetaInfo {
        @JsonProperty(value = "AverageBorderColor", access = JsonProperty.Access.WRITE_ONLY)
        private String averageBorderColor;
        @JsonProperty(value = "ColorWizBack", access = JsonProperty.Access.WRITE_ONLY)
        private String colorWizBack;
        @JsonProperty(value = "ColorWizButton", access = JsonProperty.Access.WRITE_ONLY)
        private String colorWizButton;
        @JsonProperty(value = "ColorWizButtonText", access = JsonProperty.Access.WRITE_ONLY)
        private String colorWizButtonText;
        @JsonProperty(value = "ColorWizText", access = JsonProperty.Access.WRITE_ONLY)
        private String colorWizText;

        @JsonProperty("orig-size")
        private OrigSizeInfo origSize;

        private String md5;

        @JsonProperty("orig-format")
        private String origFormat;

        @JsonProperty("processed_by_computer_vision")
        private Boolean processedByComputerVision;

        @JsonProperty("processed_by_computer_vision_description")
        private String processedByComputerVisionDescription;

        private String processing;

        public String getMd5() {
            return md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public String getOrigFormat() {
            return origFormat;
        }

        public void setOrigFormat(String origFormat) {
            this.origFormat = origFormat;
        }

        public Boolean getProcessedByComputerVision() {
            return processedByComputerVision;
        }

        public void setProcessedByComputerVision(Boolean processedByComputerVision) {
            this.processedByComputerVision = processedByComputerVision;
        }

        public String getProcessedByComputerVisionDescription() {
            return processedByComputerVisionDescription;
        }

        public void setProcessedByComputerVisionDescription(String processedByComputerVisionDescription) {
            this.processedByComputerVisionDescription = processedByComputerVisionDescription;
        }

        public String getProcessing() {
            return processing;
        }

        public void setProcessing(String processing) {
            this.processing = processing;
        }

        public OrigSizeInfo getOrigSize() {
            return origSize;
        }

        public void setOrigSize(OrigSizeInfo origSize) {
            this.origSize = origSize;
        }

        @Override
        public String toString() {
            return "MetaInfo{" +
                    "origSize=" + origSize +
                    ", md5='" + md5 + '\'' +
                    ", origFormat='" + origFormat + '\'' +
                    ", processedByComputerVision=" + processedByComputerVision +
                    ", processedByComputerVisionDescription='" + processedByComputerVisionDescription + '\'' +
                    ", processing='" + processing + '\'' +
                    '}';
        }

        public static class OrigSizeInfo {
            private int x;
            private int y;

            public int getX() {
                return x;
            }

            public void setX(int x) {
                this.x = x;
            }

            public int getY() {
                return y;
            }

            public void setY(int y) {
                this.y = y;
            }

            @Override
            public String toString() {
                return "OrigSizeInfo{" +
                        "x=" + x +
                        ", y=" + y +
                        '}';
            }
        }
    }
}
