package ru.yandex.canvas.model.direct;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.model.video.files.StreamFormat;

public class AdditionalData {

    @JsonProperty("duration")
    Double duration;

    @JsonProperty("formats")
    List<OutdoorVideoFormat> formats;

    @JsonProperty("originalWidth")
    int originalWidth;

    @JsonProperty("originalHeight")
    int originalHeight;

    public Double getDuration() {
        return duration;
    }

    public AdditionalData setDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    public List<OutdoorVideoFormat> getFormats() {
        return formats;
    }

    public AdditionalData setFormats(List<OutdoorVideoFormat> formats) {
        this.formats = formats;
        return this;
    }

    public int getOriginalWidth() {
        return originalWidth;
    }

    public void setOriginalWidth(int originalWidth) {
        this.originalWidth = originalWidth;
    }

    public int getOriginalHeight() {
        return originalHeight;
    }

    public void setOriginalHeight(int originalHeight) {
        this.originalHeight = originalHeight;
    }

    @Override
    public String toString() {
        return "AdditionalData{" +
                "duration=" + duration +
                ", formats=" + formats +
                ", originalHeight=" + originalHeight +
                ", originalWidth=" + originalWidth +
                '}';
    }

    public static class OutdoorVideoFormat {
        private Integer width;
        private Integer height;
        private String type;
        private String url;

        public OutdoorVideoFormat(StreamFormat streamFormat) {
            this.width = streamFormat.getWidth();
            this.height = streamFormat.getHeight();
            this.type = streamFormat.getMimeType();
            this.url = streamFormat.getUrl();
        }

        public OutdoorVideoFormat(Integer width, Integer height, String type, String url) {
            this.width = width;
            this.height = height;
            this.type = type;
            this.url = url;
        }

        public Integer getWidth() {
            return width;
        }

        public Integer getHeight() {
            return height;
        }

        public String getType() {
            return type;
        }

        public String getUrl() {
            return url;
        }

        @Override
        public String toString() {
            return "OutdoorVideoFormat{" +
                    "width=" + width +
                    ", height=" + height +
                    ", type='" + type + '\'' +
                    ", url='" + url + '\'' +
                    '}';
        }
    }
}
