package ru.yandex.canvas.model.direct;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.ALWAYS)
public class CreativeInfo {
    @JsonProperty("ok")
    Boolean ok;
    @JsonProperty("message")
    String message;
    @JsonProperty("creativeId")
    Long creativeId;

    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("creative")
    CreativeUploadData creative;

    public Boolean getOk() {
        return ok;
    }

    public CreativeInfo setOk(Boolean ok) {
        this.ok = ok;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public CreativeInfo setMessage(String message) {
        this.message = message;
        return this;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public CreativeInfo setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public CreativeUploadData getCreative() {
        return creative;
    }

    public CreativeInfo setCreative(CreativeUploadData creative) {
        this.creative = creative;
        return this;
    }
}
