package ru.yandex.canvas.model.direct;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.canvas.Html5Constants;
import ru.yandex.canvas.model.html5.Source;

public enum CreativeUploadComposedFrom {
    JPG("jpg"),
    GIF("gif"),
    PNG("png");

    private String value;

    CreativeUploadComposedFrom(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public static CreativeUploadComposedFrom fromStillageInfo(Source.ImageStillageInfo stillageFileInfo) {
        String ext = Html5Constants.VALID_IMAGE_MIME_TYPES.get(stillageFileInfo.getMimeType());

        if (ext != null) {
            return CreativeUploadComposedFrom.valueOf(ext.toUpperCase());
        }

        return null;
    }
}
