package ru.yandex.canvas.model.direct;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude
public class CreativeUploadData {

    @JsonProperty("creative_id")
    private Long creativeId;

    @JsonProperty("creative_type")
    private CreativeUploadType creativeType;

    @JsonProperty("creative_name")
    private String creativeName;

    @JsonProperty("preview_url")
    private String previewUrl;

    @JsonProperty("live_preview_url")
    private String livePreviewUrl;

    @JsonProperty("expanded_preview_url")
    private String expandedPreviewUrl;

    @JsonProperty("archive_url")
    private String archiveUrl;

    private Integer width;
    private Integer height;

    @JsonProperty("composed_from")
    private CreativeUploadComposedFrom composedFrom;

    @JsonProperty("stock_creative_id")
    private Long stockCreativeId;

    @JsonProperty("yabs_data")
    private YabsData yabsData;

    @JsonProperty
    private Double duration;

    @JsonProperty("preset_id")
    private Integer presetId;

    @JsonProperty("moderation_info")
    private ModerationInfo moderationInfo;

    @JsonProperty("additional_data")
    private AdditionalData additionalData;

    @JsonProperty("has_packshot")
    private Boolean hasPackshot;

    @JsonProperty("is_adaptive")
    private Boolean isAdaptive;

    @JsonProperty("is_brand_lift")
    private Boolean isBrandLift;

    public Long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
    }

    public String getCreativeName() {
        return creativeName;
    }

    public void setCreativeName(String creativeName) {
        this.creativeName = creativeName;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public void setLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
    }

    public String getExpandedPreviewUrl() {
        return expandedPreviewUrl;
    }

    public CreativeUploadData setExpandedPreviewUrl(String expandedPreviewUrl) {
        this.expandedPreviewUrl = expandedPreviewUrl;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public ModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public void setModerationInfo(ModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
    }

    public CreativeUploadType getCreativeType() {
        return creativeType;
    }

    public void setCreativeType(CreativeUploadType creativeType) {
        this.creativeType = creativeType;
    }

    public String getArchiveUrl() {
        return archiveUrl;
    }

    public void setArchiveUrl(String archiveUrl) {
        this.archiveUrl = archiveUrl;
    }

    public CreativeUploadComposedFrom getComposedFrom() {
        return composedFrom;
    }

    public void setComposedFrom(CreativeUploadComposedFrom composedFrom) {
        this.composedFrom = composedFrom;
    }

    public Long getStockCreativeId() {
        return stockCreativeId;
    }

    public void setStockCreativeId(Long stockCreativeId) {
        this.stockCreativeId = stockCreativeId;
    }

    public YabsData getYabsData() {
        return yabsData;
    }

    public void setYabsData(YabsData yabsData) {
        this.yabsData = yabsData;
    }

    public Double getDuration() {
        return duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public Integer getPresetId() {
        return presetId;
    }

    public void setPresetId(Integer presetId) {
        this.presetId = presetId;
    }

    public AdditionalData getAdditionalData() {
        return additionalData;
    }

    public CreativeUploadData setAdditionalData(AdditionalData additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public Boolean getHasPackshot() {
        return hasPackshot;
    }

    public void setHasPackshot(Boolean hasPackshot) {
        this.hasPackshot = hasPackshot;
    }

    public Boolean getIsAdaptive() { return isAdaptive; }

    public void setIsAdaptive(Boolean isAdaptive) {
        this.isAdaptive = isAdaptive;
    }

    public Boolean getIsBrandLift() {
        return isBrandLift;
    }

    public void setIsBrandLift(Boolean brandLift) {
        this.isBrandLift = brandLift;
    }

    @Override
    public String toString() {
        return "CreativeUploadData{" +
                "creativeId=" + creativeId +
                ", creativeType=" + creativeType +
                ", creativeName='" + creativeName + '\'' +
                ", previewUrl='" + previewUrl + '\'' +
                ", livePreviewUrl='" + livePreviewUrl + '\'' +
                ", archiveUrl='" + archiveUrl + '\'' +
                ", width=" + width +
                ", height=" + height +
                ", composedFrom=" + composedFrom +
                ", stockCreativeId=" + stockCreativeId +
                ", yabsData=" + yabsData +
                ", duration=" + duration +
                ", presetId=" + presetId +
                ", moderationInfo=" + moderationInfo +
                ", additionalData=" + additionalData +
                ", hasPackshot=" + hasPackshot +
                ", isAdaptive=" + isAdaptive +
                ", isBrandLift=" + isBrandLift +
                '}';
    }
}
